///////////////////////////////////////////////////////////////////////////////
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
//	Valentin Ofshteyn, June 2001
//
// DESCRIPTION:
// AttPosCommands.cpp: ObjectARX defined commands
//
///////////////////////////////////////////////////////////////////////////////

//Include files
//
#include "StdAfx.h"
#include "AttrPosEnabler.h"
#include "AdMapOracleConnection.h"
#include <dbapserv.h>
#include <string>
#include <vector>

// This is command 'APIMPORT'
AcMapOSEConnection *pConnectoin=AcMapOSEGetConnection();

//Command handler function for 'APIMPORT' command
//
void AcMapSAMPLEAPIMPORT()
{
	//check if the connection is opened
	if (!pConnectoin->IsConnected())
	{
		if (!pConnectoin->Connect("VAL", "testspat.autodesk.com", "VAL", "O"))
		{
			acutPrintf("Cannot connect to the Oracle database.");
			return;
		}
	}

	//Instantiate the objects needed for import objects
	AttrPosEnabler enabler(pConnectoin);
	AcMapOSEImport import(*pConnectoin);
	AcMapOSEQuery query(*pConnectoin);
	
	//This query should bring all the objects from the database
	std::vector<std::string> features;
	pConnectoin->Features(features);
	query.Clear();
	if (!query.AddWhereConditionInFeatures(features,"ADMPCOLOR IS NOT NULL",true))
	{
		acutPrintf("Cannot create query");
		return;
	}
	import.Import(query);

	//now we can correct the positions of the attributes
	enabler.CorrectAttributePositions();

}

//Command handler function for 'APEXPORT' command
//
void AcMapSAMPLEAPEXPORT()
{
	//check if the connection is opened
	if (!pConnectoin->IsConnected())
	{
		if (!pConnectoin->Connect("VAL", "testspat.autodesk.com", "VAL", "O"))
		{
			acutPrintf("Cannot connect to the Oracle database.");
			return;
		}
	}

	//Instantiate the objects needed for export objects
	AttrPosEnabler enabler(pConnectoin);
	AcMapOSEExport export(*pConnectoin);
	std::vector<std::string> features;
	pConnectoin->Features(features);
	export.Init(features);
	//export all objects from the drawing to the Oracle database
	export.ExportObjectsAll(acdbHostApplicationServices()->workingDatabase());
}

